<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts ģenerē personalizētu galveno lapu pēc lietotāja pieslēgšanās.
 * Apraksts: Skripts pārbauda, vai lietotājs ir autentificēts, iegūst viņa vārdu un uzvārdu no datubāzes
 *           un parāda personalizētu sveicienu ar piekļuvi dažādām sadaļām.
 */

session_start(); // Sāk sesiju, lai iegūtu lietotāja datus

// Datubāzes savienojuma parametri
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda, vai savienojums izveidots veiksmīgi
if ($conn->connect_error) {
    die("Savienojums ar datubāzi neizdevās: " . $conn->connect_error);
}

// Pārbauda, vai lietotājs ir pieslēdzies un iegūst viņa ID
$user_id = $_SESSION['user_id'] ?? null;
$first_name = "";
$last_name = "";

if ($user_id) {
    // Sagatavo vaicājumu, lai iegūtu lietotāja vārdu un uzvārdu
    $sql = "SELECT first_name, last_name FROM rb_kvalif_signup_410 WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // Ja lietotājs atrasts, iegūst viņa vārdu un uzvārdu
    if ($row = $result->fetch_assoc()) {
        $first_name = htmlspecialchars($row['first_name']); // Sanitizē izvadi, lai izvairītos no XSS uzbrukumiem
        $last_name = htmlspecialchars($row['last_name']);
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Galvenās lapas CSS -->
    <link rel="stylesheet" href="../css/main.css">

    <title>Sākumlapa</title>
</head>
<body>

<header>
    <nav>
        <ul>
            <!-- Navigācijas izvēlne ar aktīvo lapu "Sākumlapa" -->
            <li><a href="../php/main.php" class="active">Sākumlapa</a></li>
            <li><a href="../html/work-hours.html">Darba Stundas</a></li>
            <li><a href="../html/material-count.html">Materiāla Skaits</a></li>
            <li><a href="../html/faq.html">BUJ</a></li>
        </ul>

        <div class="user-info">
            <!-- Profila poga, kas ved uz lietotāja profilu -->
            <button class="profile-btn" onclick="location.href='../php/profile.php'">
                <img src="../icons/user.svg" alt="Lietotāja ikona">
            </button>
            <!-- Izrakstīšanās poga -->
            <a href="../html/index.html" class="logout">Izrakstīties</a>
        </div>
    </nav>
</header>

<div class="content">
    <!-- Personalizēts sveiciena ziņojums ar lietotāja vārdu un uzvārdu -->
    <h2 id="welcome-message">Laipni lūdzam, <?php echo $first_name . " " . $last_name; ?>!</h2>

    <!-- Kartiņu sadaļa ar saitēm uz dažādām lapām -->
    <div class="card-container">
        <div class="card" onclick="location.href='../html/work-hours.html'">
            <img src="../icons/work-hours.svg" alt="Darba stundu ikona">
            <p>Darba stundas</p>
        </div>
        <div class="card" onclick="location.href='../html/material-count.html'">
            <img src="../icons/material-count.svg" alt="Materiālu uzskaites ikona">
            <p>Materiālu uzskaite</p>
        </div>
        <div class="card" onclick="location.href='../html/faq.html'">
            <img src="../icons/faq.svg" alt="BUJ ikona">
            <p>BUJ</p>
        </div>
    </div>
</div>

</body>
</html>
